/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.collision;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.compat.PehkuiInterface;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.mixin.common.collision.IEEntity_Collision;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.render.PortalGroup;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.LimitedLogger;

public class CollisionHelper {
    private static final LimitedLogger limitedLogger = new LimitedLogger(20);
    private static boolean thisTickStagnate = false;
    private static boolean lastTickStagnate = false;

    @Nullable
    public static AABB clipBox(AABB box, Vec3 planePos, Vec3 planeNormal) {
        boolean isPushedPosInFrontOfPlane;
        boolean xForward = planeNormal.f_82479_ > 0.0;
        boolean yForward = planeNormal.f_82480_ > 0.0;
        boolean zForward = planeNormal.f_82481_ > 0.0;
        Vec3 pushedPos = new Vec3(xForward ? box.f_82288_ : box.f_82291_, yForward ? box.f_82289_ : box.f_82292_, zForward ? box.f_82290_ : box.f_82293_);
        Vec3 staticPos = new Vec3(xForward ? box.f_82291_ : box.f_82288_, yForward ? box.f_82292_ : box.f_82289_, zForward ? box.f_82293_ : box.f_82290_);
        double tOfPushedPos = Helper.getCollidingT(planePos, planeNormal, pushedPos, planeNormal);
        boolean bl = isPushedPosInFrontOfPlane = tOfPushedPos < 0.0;
        if (isPushedPosInFrontOfPlane) {
            return box;
        }
        boolean isStaticPosInFrontOfPlane = Helper.isInFrontOfPlane(staticPos, planePos, planeNormal);
        if (!isStaticPosInFrontOfPlane) {
            return null;
        }
        Vec3 afterBeingPushed = pushedPos.m_82549_(planeNormal.m_82490_(tOfPushedPos));
        return new AABB(afterBeingPushed, staticPos);
    }

    public static boolean isBoxFullyBehindPlane(Vec3 planePos, Vec3 planeNormal, AABB box) {
        boolean xForward = planeNormal.f_82479_ > 0.0;
        boolean yForward = planeNormal.f_82480_ > 0.0;
        boolean zForward = planeNormal.f_82481_ > 0.0;
        Vec3 testingPos = new Vec3(xForward ? box.f_82291_ : box.f_82288_, yForward ? box.f_82292_ : box.f_82289_, zForward ? box.f_82293_ : box.f_82290_);
        return testingPos.m_82546_(planePos).m_82526_(planeNormal) < 0.0;
    }

    public static boolean canCollideWithPortal(Entity entity, Portal portal, float partialTick) {
        if (!portal.canCollideWithEntity(entity)) {
            return false;
        }
        Vec3 cameraPosVec = entity.m_20299_(partialTick);
        boolean inFrontOfPortal = portal.isInFrontOfPortal(cameraPosVec);
        if (!inFrontOfPortal) {
            return false;
        }
        boolean inProjection = portal.isBoundingBoxInPortalProjection(entity.m_20191_());
        return inProjection;
    }

    public static double absMin(double a, double b) {
        return Math.abs(a) < Math.abs(b) ? a : b;
    }

    public static double fixCoordinateFloatingPointError(double attemptedMove, double result) {
        if (Math.abs(attemptedMove - result) < 0.001) {
            return attemptedMove;
        }
        if (Math.abs(result) < 1.0E-4) {
            return 0.0;
        }
        return result;
    }

    @Nullable
    public static VoxelShape clipVoxelShape(VoxelShape shape, Vec3 clippingPlanePos, Vec3 clippingPlaneNormal) {
        if (shape.m_83281_()) {
            return null;
        }
        AABB shapeBoundingBox = shape.m_83215_();
        boolean boxBehindPlane = CollisionHelper.isBoxFullyBehindPlane(clippingPlanePos, clippingPlaneNormal, shapeBoundingBox);
        if (boxBehindPlane) {
            return null;
        }
        boolean isFullyInFrontOfPlane = CollisionHelper.isBoxFullyBehindPlane(clippingPlanePos, clippingPlaneNormal.m_82490_(-1.0), shapeBoundingBox);
        if (isFullyInFrontOfPlane) {
            return shape;
        }
        AABB clippedBoundingBox = CollisionHelper.clipBox(shapeBoundingBox, clippingPlanePos, clippingPlaneNormal);
        if (clippedBoundingBox == null) {
            return null;
        }
        VoxelShape result = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)clippedBoundingBox), (BooleanOp)BooleanOp.f_82689_);
        return result;
    }

    private static Vec3 refHandleCollisionWithShapeProcessor(Entity entity, Vec3 attemptedMove, Function<VoxelShape, VoxelShape> filter) {
        AABB boundingBox = entity.m_20191_();
        List entityCollisions = entity.m_9236_().m_183134_(entity, boundingBox.m_82369_(attemptedMove));
        BiFunction<Vec3, AABB, Vec3> collisionFunc = (attempt, bb) -> CollisionHelper.collideBoundingBox(entity, attempt, bb, entity.m_9236_(), entityCollisions, filter);
        Vec3 collidedMovement = attemptedMove.m_82556_() == 0.0 ? attemptedMove : collisionFunc.apply(attemptedMove, boundingBox);
        boolean collideX = attemptedMove.f_82479_ != collidedMovement.f_82479_;
        boolean collideY = attemptedMove.f_82480_ != collidedMovement.f_82480_;
        boolean collideZ = attemptedMove.f_82481_ != collidedMovement.f_82481_;
        boolean collidesWithFloor = collideY && attemptedMove.f_82480_ < 0.0;
        boolean touchGround = entity.m_20096_() || collidesWithFloor;
        boolean collidesHorizontally = collideX || collideZ;
        float maxUpStep = entity.m_274421_();
        if (maxUpStep > 0.0f && touchGround && collidesHorizontally) {
            Vec3 horizontalMoveAfterVerticalStepping;
            Vec3 stepping = collisionFunc.apply(new Vec3(attemptedMove.f_82479_, (double)maxUpStep, attemptedMove.f_82481_), boundingBox);
            Vec3 verticalStep = collisionFunc.apply(new Vec3(0.0, (double)maxUpStep, 0.0), boundingBox.m_82363_(attemptedMove.f_82479_, 0.0, attemptedMove.f_82481_));
            if (verticalStep.f_82480_ < (double)maxUpStep && (horizontalMoveAfterVerticalStepping = collisionFunc.apply(new Vec3(attemptedMove.f_82479_, 0.0, attemptedMove.f_82481_), boundingBox.m_82383_(verticalStep)).m_82549_(verticalStep)).m_165925_() > stepping.m_165925_()) {
                stepping = horizontalMoveAfterVerticalStepping;
            }
            if (stepping.m_165925_() > collidedMovement.m_165925_()) {
                Vec3 movingDown = collisionFunc.apply(new Vec3(0.0, -stepping.f_82480_ + attemptedMove.f_82480_, 0.0), boundingBox.m_82383_(stepping));
                return stepping.m_82549_(movingDown);
            }
        }
        return collidedMovement;
    }

    @IPVanillaCopy
    public static Vec3 handleCollisionWithShapeProcessor(Entity entity, AABB boundingBox, Level world, Vec3 attemptedMove, Function<VoxelShape, VoxelShape> filter, Direction gravity, double steppingScale) {
        Direction jumpDirection = gravity.m_122424_();
        Direction.Axis gravityAxis = gravity.m_122434_();
        List entityCollisions = world.m_183134_(entity, boundingBox.m_82369_(attemptedMove));
        BiFunction<Vec3, AABB, Vec3> collisionFunc = (attempt, bb) -> CollisionHelper.collideBoundingBox(entity, attempt, bb, world, entityCollisions, filter);
        Vec3 collidedMovement = attemptedMove.m_82556_() == 0.0 ? attemptedMove : collisionFunc.apply(attemptedMove, boundingBox);
        Vec3 collisionDelta = attemptedMove.m_82546_(collidedMovement);
        boolean collidesOnGravityAxis = Helper.getCoordinate(collisionDelta, gravityAxis) != 0.0;
        boolean attemptToMoveAlongGravity = Helper.getSignedCoordinate(attemptedMove, gravity) > 0.0;
        boolean collidesWithFloor = collidesOnGravityAxis && attemptToMoveAlongGravity;
        boolean touchGround = entity.m_20096_() || collidesWithFloor;
        boolean collidesHorizontally = CollisionHelper.movesOnNonGravityAxis(collisionDelta, gravityAxis);
        float maxUpStep = entity.m_274421_() * PehkuiInterface.invoker.getBaseScale(entity);
        if (steppingScale > 1.0) {
            maxUpStep = (float)((double)maxUpStep * steppingScale);
        }
        if (maxUpStep > 0.0f && touchGround && collidesHorizontally) {
            Vec3 horizontalMoveAfterVerticalStepping;
            Vec3 stepping = collisionFunc.apply(Helper.putSignedCoordinate(attemptedMove, jumpDirection, maxUpStep), boundingBox);
            Vec3 expandVec = Helper.putSignedCoordinate(attemptedMove, gravity, 0.0);
            Vec3 verticalStep = collisionFunc.apply(Helper.putSignedCoordinate(Vec3.f_82478_, jumpDirection, maxUpStep), boundingBox.m_82369_(expandVec));
            if (Helper.getSignedCoordinate(verticalStep, jumpDirection) < (double)maxUpStep + 0.001 && Helper.getDistanceSqrOnAxisPlane(horizontalMoveAfterVerticalStepping = collisionFunc.apply(expandVec, boundingBox.m_82383_(verticalStep)).m_82549_(verticalStep), gravityAxis) > Helper.getDistanceSqrOnAxisPlane(stepping, gravityAxis)) {
                stepping = horizontalMoveAfterVerticalStepping;
            }
            if (Helper.getDistanceSqrOnAxisPlane(stepping, gravityAxis) > Helper.getDistanceSqrOnAxisPlane(collidedMovement, gravityAxis)) {
                double steppingVerticalLen = Helper.getSignedCoordinate(stepping, jumpDirection);
                double attemptMoveVerticalLen = Helper.getSignedCoordinate(attemptedMove, jumpDirection);
                Vec3 movingDown = collisionFunc.apply(Helper.putSignedCoordinate(Vec3.f_82478_, jumpDirection, -steppingVerticalLen + attemptMoveVerticalLen), boundingBox.m_82383_(stepping));
                return stepping.m_82549_(movingDown);
            }
        }
        return collidedMovement;
    }

    public static boolean movesOnNonGravityAxis(Vec3 vec, Direction.Axis gravityAxis) {
        return switch (gravityAxis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (vec.f_82480_ != 0.0 || vec.f_82481_ != 0.0) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Y -> {
                if (vec.f_82479_ != 0.0 || vec.f_82481_ != 0.0) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Z -> vec.f_82479_ != 0.0 || vec.f_82480_ != 0.0;
        };
    }

    @IPVanillaCopy
    public static Vec3 collideBoundingBox(Entity entity, Vec3 vec, AABB collisionBox, Level level, List<VoxelShape> potentialHits, Function<VoxelShape, VoxelShape> shapeProcessor) {
        boolean addWorldBorderCollision;
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(potentialHits.size() + 1));
        for (VoxelShape potentialHit : potentialHits) {
            VoxelShape processed = shapeProcessor.apply(potentialHit);
            if (processed == null) continue;
            builder.add((Object)processed);
        }
        WorldBorder worldBorder = level.m_6857_();
        Vec3 boundingBoxCenter = collisionBox.m_82399_();
        boolean bl = addWorldBorderCollision = worldBorder.m_156093_(boundingBoxCenter.f_82479_, boundingBoxCenter.f_82481_) && worldBorder.m_61941_(boundingBoxCenter.f_82479_, boundingBoxCenter.f_82481_) < 32.0;
        if (addWorldBorderCollision) {
            builder.add((Object)worldBorder.m_61946_());
        }
        Iterable blockCollisions = level.m_186434_(entity, collisionBox.m_82369_(vec));
        for (VoxelShape blockCollision : blockCollisions) {
            VoxelShape processed = shapeProcessor.apply(blockCollision);
            if (processed == null) continue;
            builder.add((Object)processed);
        }
        return IEEntity_Collision.ip_CollideWithShapes(vec, collisionBox, (List<VoxelShape>)builder.build());
    }

    public static AABB transformBox(PortalLike portal, AABB originalBox) {
        if (portal.getRotation() == null && portal.getScale() == 1.0) {
            return originalBox.m_82383_(portal.getDestPos().m_82546_(portal.getOriginPos()));
        }
        return Helper.transformBox(originalBox, portal::transformPoint);
    }

    public static Level getWorld(boolean isClient, ResourceKey<Level> dimension) {
        if (isClient) {
            return CHelper.getClientWorld(dimension);
        }
        return MiscHelper.getServer().m_129880_(dimension);
    }

    public static boolean isCollidingWithAnyPortal(Entity entity) {
        return ((IEEntity)entity).ip_getCollidingPortal() != null;
    }

    public static void updateCollidingPortalForWorld(Level world, float tickDelta) {
        world.m_46473_().m_6180_("update_colliding_portal");
        List<Portal> globalPortals = GlobalPortalStorage.getGlobalPortals(world);
        Iterable<Entity> worldEntityList = McHelper.getWorldEntityList(world);
        for (Entity entity : worldEntityList) {
            if (entity instanceof Portal) {
                Portal portal = (Portal)entity;
                CollisionHelper.notifyCollidingPortals(portal, tickDelta);
                continue;
            }
            AABB entityBoundingBoxStretched = CollisionHelper.getStretchedBoundingBox(entity);
            for (Portal globalPortal : globalPortals) {
                AABB globalPortalBoundingBox = globalPortal.m_20191_();
                if (!entityBoundingBoxStretched.m_82381_(globalPortalBoundingBox) || !CollisionHelper.canCollideWithPortal(entity, globalPortal, tickDelta)) continue;
                ((IEEntity)entity).ip_notifyCollidingWithPortal(globalPortal);
            }
        }
        world.m_46473_().m_7238_();
    }

    public static void init() {
        IPGlobal.postServerTickSignal.connect(() -> {
            for (ServerLevel world : MiscHelper.getServer().m_129785_()) {
                CollisionHelper.updateCollidingPortalForWorld((Level)world, 0.0f);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient() {
        IPGlobal.postClientTickSignal.connect(CollisionHelper::tickClient);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void tickClient() {
        CollisionHelper.updateClientCollidingStatus();
        CollisionHelper.updateClientStagnateStatus();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void updateClientCollidingStatus() {
        if (ClientWorldLoader.getIsInitialized()) {
            for (ClientLevel world : ClientWorldLoader.getClientWorlds()) {
                CollisionHelper.updateCollidingPortalForWorld((Level)world, 0.0f);
            }
        }
    }

    public static void notifyCollidingPortals(Portal portal, float partialTick) {
        if (!portal.teleportable) {
            return;
        }
        AABB portalBoundingBox = portal.m_20191_();
        McHelper.foreachEntitiesByBoxApproximateRegions(Entity.class, portal.m_9236_(), portalBoundingBox, 8.0, entity -> {
            if (entity instanceof Portal) {
                return;
            }
            AABB entityBoxStretched = CollisionHelper.getStretchedBoundingBox(entity);
            if (!entityBoxStretched.m_82381_(portalBoundingBox)) {
                return;
            }
            boolean canCollideWithPortal = CollisionHelper.canCollideWithPortal(entity, portal, partialTick);
            if (!canCollideWithPortal) {
                return;
            }
            ((IEEntity)entity).ip_notifyCollidingWithPortal(portal);
        });
    }

    public static AABB getStretchedBoundingBox(Entity entity) {
        Vec3 backwardExpand = McHelper.lastTickPosOf(entity).m_82546_(entity.m_20182_());
        Vec3 forwardExpand = McHelper.getWorldVelocity(entity);
        AABB box = entity.m_20191_().m_82369_(forwardExpand.m_82490_(1.2)).m_82369_(backwardExpand);
        float scale = PehkuiInterface.invoker.getBaseScale(entity);
        if (scale > 4.0f) {
            box = box.m_82400_((double)scale);
        }
        return box;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void informClientStagnant() {
        thisTickStagnate = true;
        limitedLogger.log("client movement stagnated");
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void updateClientStagnateStatus() {
        if (thisTickStagnate && lastTickStagnate) {
            Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237115_((String)"imm_ptl.stagnate_movement"), false);
        } else if (!thisTickStagnate && lastTickStagnate) {
            Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237113_((String)""), false);
        }
        lastTickStagnate = thisTickStagnate;
        thisTickStagnate = false;
    }

    public static PortalLike getCollisionHandlingUnit(Portal portal) {
        if (portal.getIsGlobal()) {
            return portal;
        }
        if (portal.m_9236_().m_5776_()) {
            return CollisionHelper.getCollisionHandlingUnitClient(portal);
        }
        return portal;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static PortalLike getCollisionHandlingUnitClient(Portal portal) {
        return PortalGroup.getPortalUnit(portal);
    }

    @Deprecated
    public static Portal chooseCollidingPortalBetweenTwo(Entity entity, Portal a, Portal b) {
        boolean movingTowardsB;
        Vec3 velocity = McHelper.getWorldVelocity(entity);
        boolean movingTowardsA = velocity.m_82526_(a.getNormal()) < 0.0;
        boolean bl = movingTowardsB = velocity.m_82526_(b.getNormal()) < 0.0;
        if (movingTowardsA) {
            return a;
        }
        return b;
    }

    @Nullable
    public static AABB getTotalBlockCollisionBox(Entity entity, AABB box, Function<VoxelShape, VoxelShape> shapeFilter) {
        Iterable collisions = entity.m_9236_().m_186434_(entity, box);
        AABB collisionUnion = null;
        for (VoxelShape c : collisions) {
            VoxelShape currCollision = shapeFilter.apply(c);
            if (currCollision == null || currCollision.m_83281_()) continue;
            AABB collisionBoundingBox = currCollision.m_83215_();
            if (collisionUnion == null) {
                collisionUnion = collisionBoundingBox;
                continue;
            }
            collisionUnion = collisionUnion.m_82367_(collisionBoundingBox);
        }
        return collisionUnion;
    }
}

